//___________________________________________________________________
//___________________________________________________________________
//  Copyright : 2021 BY HOLTEK SEMICONDUCTOR INC
//  File Name : ANALOG.h
// Description: ANALOG 
//Targer Board: None
//   MCU      : BH67F2265
//   Author   : ming
//   Date     : 20210308
//   Version  : V00
//   History  :
//___________________________________________________________________
//___________________________________________________________________


#ifndef _ANALOG_H_
#define _ANALOG_H_

   

void fun_PGA1_INIT(u8 lu8v_gain1,u8 lu8v_gain2);
void fun_PGA2_INIT();
void fun_SCF_INIT(u8 lu8v_scf_gain);
void fun_CCurrent_INIT();

void fun_En_Analog_power();
void fun_Dis_Analog_power();

void fun_Dis_Charge_Pump();
void fun_battery_check();
void fun_dis_battery_check();
void fun_en_battery_check();
void ANALOG_TEST();
void SCF_TEST();

//                           @--------------_pgac0---------------@
//  ______________________________________________________________________________
// | Bit  |  Bit7  |  Bit6  |  Bit5  |  Bit4  |  Bit3  |  Bit2  |  Bit1  |  Bit0  |
//  ______________________________________________________________________________
// | Name |  PGAEN |  PGAA01|  PGAA00|PGAVREF4|PGAVREF3|PGAVREF2|PGAVREF1|PGAVREF0|
// |______________________________________________________________________________
// | POR  |   0    |   0    |   0    |   0    |   0    |   0    |   0    |   0    |
// |_______________________________________________________________________________
// Bit 7 PGAEN：
// 	0：disable– all PGA and SCF 
// 	1：enable
// Bit 6~5 PGAA01~PGAA00：PGA1 gain1 set
// 	00：8
// 	01：16
// 	10：32
// 	11：64
// Bit 4~0 PGAVREF4~PGAVREF0：PGA1 bais votage
// 	PGA1 bais votage= ([PGAVREF4:0] / 32) ×VOREG
#define Pgac0_Default 	0B00000011	//設置偏置電壓 當前設置為1/8AVDD


#define Pgac1_gain1_8 	0B00000000	//
#define Pgac1_gain1_16 	0B00100000	//
#define Pgac1_gain1_32 	0B01000000	//
#define Pgac1_gain1_64 	0B01100000	//
       
//                           @--------------_pgac1---------------@
//  ______________________________________________________________________________
// | Bit  |  Bit7  |  Bit6  |  Bit5  |  Bit4  |  Bit3  |  Bit2  |  Bit1  |  Bit0  |
//  ______________________________________________________________________________
// | Name |  CPEN  |  BIPGA1|  BIPGA0|PGAA14  |PGAA13  |PGAA12  |PGAA11  |PGAA10  |
// |______________________________________________________________________________
// | POR  |   0    |   0    |   0    |   0    |   0    |   0    |   0    |   0    |
// |_______________________________________________________________________________
// Bit 7 CPEN：PGA1
// 	0：disable
// 	1：enable
// Bit 6~5 BIPGA1~BIPGA0：
// Bit 4~0 PGAA14~PGAA10：PGA1 gain2 set
// 	0 ~ 31
// 	Gain = (1 + [PGAA14:PGAA10] / 32
#define Pgac1_Default 	0B00000000	//


//                           @--------------_pgac2---------------@
//  ______________________________________________________________________________
// | Bit  |  Bit7  |  Bit6  |  Bit5  |  Bit4  |  Bit3  |  Bit2  |  Bit1  |  Bit0  |
//  ______________________________________________________________________________
// | Name |  D7    |  D6    |  D5    |D4      |  D3    |  D2    |  D1    |  D0    |
// |______________________________________________________________________________
// | POR  |   0    |   0    |   0    |   0    |   0    |   0    |   0    |   0    |
// |_______________________________________________________________________________
// Bit 7~0 D7~D0：PGA2
// 	PGA2 bais votage= (3.3V ×PGAC2[7:0] / 256)
#define Pgac2_Default 	0B00000000	//

       

//                           @--------------_scfc0---------------@
//  ______________________________________________________________________________
// | Bit  |  Bit7  |  Bit6  |  Bit5  |  Bit4  |  Bit3  |  Bit2  |  Bit1  |  Bit0  |
//  ______________________________________________________________________________
// | Name |  SCFLF1|  SCFLF0|  SCFA5 |SCFA4   |  SCFA3 |  SCFA2 |  SCFA1 |  SCFA0 |
// |______________________________________________________________________________
// | POR  |   0    |   0    |   0    |   0    |   0    |   0    |   0    |   0    |
// |_______________________________________________________________________________
// Bit 7~6  SCFLF1~SCFLF0：
// 	00：9Hz
// 	01：10Hz
// 	10：11 Hz
// 	11 ：12Hz
// Bit 5~0  SCFA5~SCFA0：
// 	0~63
// 	Gain = 56 + 4  × SCFA[5:0]
#define Scfc0_Default 	0B00000000	// 9hz 
//#define Scfc0_Default 	0B11000000	// 9hz 

//                           @--------------_scfc1---------------@
//  ______________________________________________________________________________
// | Bit  |  Bit7  |  Bit6  |  Bit5  |  Bit4  |  Bit3  |  Bit2  |  Bit1  |  Bit0  |
//  ______________________________________________________________________________
// | Name |  —     | SCFADSF| SCFADC |SCFCKP2 | SCFCKP1| SCFCKP0|  —     |  —     |
// |______________________________________________________________________________
// | POR  |   0    |   0    |   0    |   0    |   0    |   0    |   0    |   0    |
// |_______________________________________________________________________________
// Bit 7 
// Bit 6   SCFADSF 
// 	0：除能A/D转换器测量SCF 输出信号
// 	1：使能A/D转换器测量SCF 输出信号
// Bit 5   SCFADC：A/D 转换器自动测量SCF 输出信号使能/ 除能控制位
// 	0：除能
// 	1：使能 – A /D转换器将自动开始SCF 信号的A/D 转换
// Bit 4~2  SCFCKP2~SCFCKP0 ：SCF 时钟分频
// 	000：fSYS /8
// 	001：f SYS /16
// 	010：f SYS /32
// 	011：f SYS /64
// 	100：f SYS /128
// 	101：f SYS /256
// 	11 0：fSYS /512
// 	111：f SYS /1024
// Bit 1~0  
#define Scfc1_Default 	0B01011100	//f SYS /1024 = fscf


//                           @--------------_ccvrefc---------------@
//  ______________________________________________________________________________
// | Bit  |  Bit7  |  Bit6  |  Bit5  |  Bit4  |  Bit3  |  Bit2  |  Bit1  |  Bit0  |
//  ______________________________________________________________________________
// | Name |CCVREFEN| BATEN  |   —    |    —   | CCVREF3| CCVREF2|CCVREF1 |CCVREF0 |
// |______________________________________________________________________________
// | POR  |   0    |   0    |   0    |   0    |   0    |   0    |   0    |   0    |
// |_______________________________________________________________________________


#define Scfckd_Default 	15	//
       
//                           @--------------scfckd---------------@
//  ______________________________________________________________________________
// | Bit  |  Bit7  |  Bit6  |  Bit5  |  Bit4  |  Bit3  |  Bit2  |  Bit1  |  Bit0  |
//  ______________________________________________________________________________
// | Name |SCFCKD7| SCFCKD6| SCFCKD5 |SCFCKD4 | SCFCKD3| SCFCKD2|SCFCKD1 |SCFCKD0 |
// |______________________________________________________________________________
// | POR  |   0    |   0    |   0    |   0    |   0    |   0    |   0    |   0    |
// |_______________________________________________________________________________
// Bit 7   C CVREFEN ：传感器恒定电流电路使能/ 除能控制位
// 	0：除能 – 恒定电流电路关闭
// 	1：使能
// Bit 6   B ATEN ：电池电压检测电路使能/ 除能控制位
// 	0：除能 – 电池检测电路关闭
// 	1：使能
// Bit 5~4  未定义，读为“0”
// Bit 3~0  C CVREF3~CCVREF0：传感器恒定电流发生器参考电压选择位
// 	0000：0.2V
// 	0001：0.25V
// 	0010：0.3V
// 	0011 ：0.35V
// 	0100：0.4V
// 	0101：0.45V
// 	0110：0.5V
// 	0111 ：0.55V
// 	1000：0.6V
// 	1001：0.65V
// 	1010：0.7V
// 	1011 ：0.75V
// 	11 00：0.8V
// 	11 01：0.85V
// 	1110：0.9V
// 	1111 ：0.95V
#define Ccvrefc_Default 	0b10000001 //0b10000001	// 0.25


//                           @--------------_PGAC3---------------@
//  ______________________________________________________________________________
// | Bit  |  Bit7  |  Bit6  |  Bit5  |  Bit4  |  Bit3  |  Bit2  |  Bit1  |  Bit0  |
//  ______________________________________________________________________________
// | Name |  PGAEN |  PGA2G |    —  |SCFVREF4|SCFVREF3|SCFVREF2|SCFVREF1|SCFVREF0|
// |______________________________________________________________________________
// | POR  |   0    |   0    |   0    |   0    |   0    |   0    |   0    |   0    |
// |_______________________________________________________________________________
// Bit 4~0 SCFVREF4~SCFVREF0：SCF offset votage 
// 	SCF offset votage = ([SCFVREF4:0] / 32) ×VOREG
#define PGAC3_Default 0B11110001//	0b00010000	// 1/2 VOREG

  
//                           @--------------_chprc---------------@
//  ______________________________________________________________________________
// | Bit  |  Bit7  |  Bit6  |  Bit5  |  Bit4  |  Bit3  |  Bit2  |  Bit1  |  Bit0  |
//  ______________________________________________________________________________
// | Name |CHPCKD4 |CHPCKD3 |CHPCKD2 |CHPCKD1 |CHPCKD0 |    —   |  CHPEN | REGCEN |
// |______________________________________________________________________________
// | POR  |   0    |   0    |   0    |   0    |   0    |   0    |   0    |   0    |
// |_______________________________________________________________________________
// Bit 7~3 CHPCKD4~CHPCKD0：
// 	1~32。
// 	充电泵时钟= (fSYS/16) / (CHPCKD+1)
// 	充电泵时钟应选择尽可能接近20kHz。
// Bit 2 
// Bit 1 CHPEN：
// Bit 0 REGCEN：
#define Chprc_Default 	0b11000000	// 1/2 VOREG

#endif

